/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.schedops.HMCScheduler;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.schedops.SchedulerException;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.sa.ESAXmitServiceInfoSchedulable;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.p.sa.XMITServiceInfoTransmitPanelBean;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class XMITServiceInfoTransmitTasklet
extends PanelTasklet
implements ServiceAgentAttr {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[XMITServiceInfoTransmitTasklet] ";
    private PanelHandler mainPanelHandler;
    private PanelHandler currentPanel;

    public XMITServiceInfoTransmitTasklet() {
        this.currentPanel = this.mainPanelHandler = new PanelHandler(){

            public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
                if (request.isDisposed() || request.isCanceled()) {
                    Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] Terminating the task");
                    response.terminate();
                } else {
                    TaskActionEvent event = (TaskActionEvent)request.getData("event");
                    String elementName = event.getElementName();
                    Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]       event: " + event);
                    Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] elementName: " + elementName);
                    if (elementName.endsWith("SendButton")) {
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] <--> Got SendButton");
                        ServiceAgentUtils.scheduleXmitPMImmed(new ServiceAgentAttr.ESAbatchXmitPMImmed());
                        try {
                            Object schedulable = null;
                            Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] Start Service Agent SchedOps");
                            Calendar now = Calendar.getInstance();
                            Schedule schedule = new Schedule(now.getTime(), 1200000L, 1L, 1L);
                            ESAXmitServiceInfoSchedulable operation = new ESAXmitServiceInfoSchedulable();
                            HMC target = HMC.getHMC();
                            ScheduledOperation schedop = new ScheduledOperation(target, operation, schedule, new ServiceAgentAttr.ESAbatchXmitImmed());
                            target.getScheduler().addScheduledOperation(schedop);
                        }
                        catch (Throwable t) {
                            Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] caught exception:");
                            Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, t);
                        }
                        XMITServiceInfoTransmitTasklet.this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA0000E"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "Ok.button")});
                        response.noAction();
                    } else if (elementName.endsWith("OKButton")) {
                        XMITServiceInfoTransmitPanelBean siPB = (XMITServiceInfoTransmitPanelBean)request.getData("bean");
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] Frequency: " + siPB.getFrequency());
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      Time: " + siPB.getTime());
                        Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet]      Time: " + siPB.isXmitScheduleSetting());
                        ServiceAgentUtils.setExecutionSetting(siPB.isXmitScheduleSetting());
                        ServiceAgentUtils.setExecutionFrequency(siPB.getFrequency());
                        int freq = siPB.getFrequency();
                        Calendar cal = siPB.getTime();
                        Date date = cal.getTime();
                        long ExecutionTimeOfDay = date.getTime();
                        ServiceAgentUtils.setExecutionTimeOfDay(ExecutionTimeOfDay);
                        XMITServiceInfoTransmitTasklet.this.removeScheduledOps();
                        if (siPB.isXmitScheduleSetting()) {
                            ServiceAgentUtils.scheduleXmitPMSched(new ServiceAgentAttr.ESAbatchXmitPMSched());
                            try {
                                Object schedulable = null;
                                Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] New Schedulable : Service Agent SchedOps");
                                Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] Start date to be scheduled = " + date.getTime());
                                Schedule schedule = new Schedule(date, 1200000L, -1L, (long)freq * 86400000L);
                                ESAXmitServiceInfoSchedulable operation = new ESAXmitServiceInfoSchedulable();
                                HMC target = HMC.getHMC();
                                Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] ScheduledOperation options: Scheduled");
                                ScheduledOperation schedop = new ScheduledOperation(target, operation, schedule, new ServiceAgentAttr.ESAbatchXmitSched());
                                target.getScheduler().addScheduledOperation(schedop);
                            }
                            catch (Throwable t) {
                                Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] caught exception:");
                                Trace.trace(XMITServiceInfoTransmitTasklet.TRACE_MASKF, t);
                            }
                        }
                        response.noAction();
                    } else {
                        response.noAction();
                    }
                }
            }
        };
        Trace.trace(TRACE_MASKT, "[XMITServiceInfoTransmitTasklet] .init");
    }

    private static void setControls(XMITServiceInfoTransmitPanelBean siPB) {
        if (ServiceAgentUtils.getExecutionSetting()) {
            siPB.enableControl("Frequency");
            siPB.enableControl("Time");
        } else {
            siPB.enableControl("Frequency");
            siPB.enableControl("Time");
        }
    }

    public void logException(Throwable throwable) {
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        if (taskletRequest.isInitialRequest()) {
            XMITServiceInfoTransmitPanelBean siPB = new XMITServiceInfoTransmitPanelBean();
            long ExecutionTimeOfDay = ServiceAgentUtils.getExecutionTimeOfDay();
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(ExecutionTimeOfDay));
            siPB.setTime(cal);
            siPB.setXmitScheduleSetting(ServiceAgentUtils.getExecutionSetting());
            siPB.setFrequency(ServiceAgentUtils.getExecutionFrequency());
            Trace.trace(TRACE_MASKF, "siPB.getFrequency: " + siPB.getFrequency());
            XMITServiceInfoTransmitTasklet.setControls(siPB);
            taskletResponse.replace("com.ibm.hwmca.p.sa.res.ServiceAgent", "XMITServiceInfoTransmit", siPB);
        } else {
            this.currentPanel.service(taskletRequest, taskletResponse);
        }
    }

    private void removeScheduledOps() {
        Trace.trace(TRACE_MASKT, "--> removeScheduledOps()");
        try {
            HMCScheduler scheduler = HMCScheduler.getHMCScheduler();
            ESAXmitServiceInfoSchedulable operation = new ESAXmitServiceInfoSchedulable();
            HMC target = HMC.getHMC();
            List listOfScheduledOps = scheduler.getScheduledOperations(target, operation);
            int size = listOfScheduledOps.size();
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] number of scheduled ops to review: " + size);
            for (int ix = 0; ix < size; ++ix) {
                if (listOfScheduledOps.get(ix) != null) {
                    ScheduledOperation so = (ScheduledOperation)listOfScheduledOps.get(ix);
                    Object xmitParms = so.getOperationParameters();
                    if (xmitParms != null) {
                        Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] looking at schedops object: " + xmitParms.getClass().getName());
                        if (!xmitParms.getClass().getName().endsWith("ESAbatchXmitSched") && !xmitParms.getClass().getName().endsWith("ESAbatchXmitPMSched")) continue;
                        Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] Found scheduled event to remove: " + xmitParms.getClass().getName());
                        try {
                            scheduler.removeScheduledOperation(so);
                        }
                        catch (SchedulerException e) {
                            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] caught OperationRemoveException ");
                            Trace.trace(TRACE_MASKF, e);
                        }
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "xmitParms was null");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "no schedule ops to process");
            }
        }
        catch (Throwable t) {
            Trace.trace(TRACE_MASKF, "[XMITServiceInfoTransmitTasklet] caught exception");
            Trace.trace(TRACE_MASKF, t);
        }
        Trace.trace(TRACE_MASKT, "[XMITServiceInfoTransmitTasklet] <-- removeScheduledOps()");
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;
    }
}

